/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;

public class EasyGridBagLayout
extends GridBagLayout {
    public static final Insets DEFAULT_INSETS = new Insets(2, 2, 2, 2);
    private int _width;
    private int _height;
    private int _anchor;
    private int _fill;
    private int _ipadx;
    private int _ipady;
    private Insets _insets;
    private JPanel _panel;

    public EasyGridBagLayout(JPanel jPanel) throws NullPointerException {
        if (jPanel == null) {
            throw new NullPointerException();
        }
        this._width = 1;
        this._height = 1;
        this._anchor = 17;
        this._fill = 0;
        this._ipadx = 0;
        this._ipady = 0;
        this._insets = new Insets(EasyGridBagLayout.DEFAULT_INSETS.top, EasyGridBagLayout.DEFAULT_INSETS.left, EasyGridBagLayout.DEFAULT_INSETS.bottom, EasyGridBagLayout.DEFAULT_INSETS.right);
        this._panel = jPanel;
    }

    public void setAnchor(int n) {
        this._anchor = n;
    }

    public void setFill(int n) {
        this._fill = n;
    }

    public void setInsets(Insets insets) {
        this._insets.top = insets.top;
        this._insets.left = insets.left;
        this._insets.bottom = insets.bottom;
        this._insets.right = insets.right;
    }

    public void addComponent(Component component, int n, int n2) {
        this.addComponent(component, n, n2, this._width, this._height, this._anchor, this._fill, this._insets);
    }

    public void addComponent(Component component, int n, int n2, int n3, int n4, int n5, int n6, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
        gridBagConstraints.insets = this._insets;
        gridBagConstraints.ipadx = this._ipadx;
        gridBagConstraints.ipady = this._ipady;
        double d = 0.0;
        double d2 = 0.0;
        if (n3 > 1) {
            d = 1.0;
        }
        if (n4 > 1) {
            d2 = 1.0;
        }
        switch (n6) {
            case 2: {
                gridBagConstraints.weightx = d;
                gridBagConstraints.weighty = 0.0;
                break;
            }
            case 3: {
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = d2;
                break;
            }
            case 1: {
                gridBagConstraints.weightx = d;
                gridBagConstraints.weighty = d2;
                break;
            }
            case 0: {
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
            }
        }
        this._panel.add(component, gridBagConstraints);
    }

    public void addAnchoredComponent(Component component, int n, int n2, int n3) {
        this.addComponent(component, n, n2, this._width, this._height, n3, this._fill, this._insets);
    }

    public void addFilledComponent(Component component, int n, int n2, int n3) {
        this.addComponent(component, n, n2, this._width, this._height, this._anchor, n3, this._insets);
    }

    public void setMinimumWidth(int n, int n2) {
        int[] nArray = this.columnWidths;
        if (nArray == null) {
            nArray = new int[n + 1];
        } else if (nArray.length < n + 1) {
            nArray = new int[n + 1];
            System.arraycopy(this.columnWidths, 0, nArray, 0, this.columnWidths.length);
        }
        nArray[n] = n2;
        this.columnWidths = nArray;
    }
}

