/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.Photon;
import edu.colorado.phet.common.photonabsorption.model.molecules.CH4;
import edu.colorado.phet.common.photonabsorption.model.molecules.CO;
import edu.colorado.phet.common.photonabsorption.model.molecules.CO2;
import edu.colorado.phet.common.photonabsorption.model.molecules.H2O;
import edu.colorado.phet.common.photonabsorption.model.molecules.N2;
import edu.colorado.phet.common.photonabsorption.model.molecules.NO2;
import edu.colorado.phet.common.photonabsorption.model.molecules.O2;
import edu.colorado.phet.common.photonabsorption.model.molecules.O3;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotonAbsorptionModel {
    private static final Point2D PHOTON_EMISSION_LOCATION = new Point2D.Double(-1400.0, 0.0);
    private static final Point2D SINGLE_MOLECULE_LOCATION = new Point2D.Double(0.0, 0.0);
    private static final Point2D CONTAINMENT_AREA_CENTER = new Point2D.Double(0.0, 0.0);
    private static final Rectangle2D CONTAINMENT_AREA_RECT = new Rectangle2D.Double(CONTAINMENT_AREA_CENTER.getX() - 1550.0, CONTAINMENT_AREA_CENTER.getY() - 1500.0, 3100.0, 3000.0);
    private static final PhotonTarget DEFAULT_PHOTON_TARGET = PhotonTarget.SINGLE_CH4_MOLECULE;
    private static final Map<Class<? extends Molecule>, Integer> MAX_ATMOSPHERE_CONCENTRATIONS = new HashMap<Class<? extends Molecule>, Integer>(){
        {
            this.put(N2.class, 15);
            this.put(O2.class, 15);
            this.put(CO2.class, 15);
            this.put(CH4.class, 15);
            this.put(H2O.class, 15);
        }
    };
    private static final Random RAND = new Random();
    private static final ArrayList<Point2D> GRID_POINTS = new ArrayList();
    private final EventListenerList listeners = new EventListenerList();
    private final ArrayList<Photon> photons = new ArrayList();
    private double photonWavelength = 5.8E-7;
    private final ArrayList<Molecule> activeMolecules = new ArrayList();
    private final PhotonTarget initialPhotonTarget;
    private PhotonTarget photonTarget = null;
    private double photonEmissionCountdownTimer = Double.POSITIVE_INFINITY;
    private double photonEmissionPeriodTarget = Double.POSITIVE_INFINITY;
    private double previousEmissionAngle = 0.0;
    private final ArrayList<Molecule> configurableAtmosphereMolecules = new ArrayList();
    private final Molecule.Adapter moleculePhotonEmissionListener = new Molecule.Adapter(){

        public void photonEmitted(Photon photon) {
            PhotonAbsorptionModel.this.photons.add(photon);
            PhotonAbsorptionModel.this.notifyPhotonAdded(photon);
        }

        public void brokeApart(Molecule molecule) {
            PhotonAbsorptionModel.this.removeOldTarget();
            ArrayList<Molecule> arrayList = molecule.getBreakApartConstituents();
            for (Molecule molecule2 : arrayList) {
                PhotonAbsorptionModel.this.activeMolecules.add(molecule2);
            }
            PhotonAbsorptionModel.this.finishAddingMolecules();
        }
    };

    private void finishAddingMolecules() {
        for (Molecule molecule : this.activeMolecules) {
            molecule.addListener(this.moleculePhotonEmissionListener);
            this.notifyMoleculeAdded(molecule);
        }
        this.notifyPhotonTargetChanged();
    }

    private void removeOldTarget() {
        ArrayList<Molecule> arrayList = new ArrayList<Molecule>(this.activeMolecules);
        this.activeMolecules.clear();
        for (Molecule molecule : arrayList) {
            this.notifyMoleculeRemoved(molecule);
        }
    }

    public PhotonAbsorptionModel(ConstantDtClock constantDtClock) {
        this(constantDtClock, DEFAULT_PHOTON_TARGET);
    }

    public PhotonAbsorptionModel(ConstantDtClock constantDtClock, PhotonTarget photonTarget) {
        this.initialPhotonTarget = photonTarget;
        constantDtClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                PhotonAbsorptionModel.this.stepInTime(clockEvent.getSimulationTimeChange());
            }
        });
    }

    public void reset() {
        this.removeAllPhotons();
        for (Molecule molecule : this.activeMolecules) {
            molecule.reset();
        }
        this.setPhotonTarget(this.initialPhotonTarget);
        this.setEmittedPhotonWavelength(8.5E-7);
        this.setPhotonEmissionPeriod(Double.POSITIVE_INFINITY);
        this.resetConfigurableAtmosphere();
        this.notifyModelReset();
    }

    public void stepInTime(double d) {
        if (this.photonEmissionCountdownTimer != Double.POSITIVE_INFINITY) {
            this.photonEmissionCountdownTimer -= d;
            if (this.photonEmissionCountdownTimer <= 0.0) {
                this.emitPhoton();
                this.photonEmissionCountdownTimer = this.photonEmissionPeriodTarget;
            }
        }
        ArrayList<Photon> arrayList = new ArrayList<Photon>();
        for (Photon object : this.photons) {
            object.stepInTime(d);
            if (object.getLocation().getX() - PHOTON_EMISSION_LOCATION.getX() <= 4500.0) {
                for (Molecule molecule : this.activeMolecules) {
                    if (!molecule.queryAbsorbPhoton(object)) continue;
                    arrayList.add(object);
                }
                continue;
            }
            arrayList.add(object);
        }
        for (Photon photon : arrayList) {
            this.photons.remove(photon);
            this.notifyPhotonRemoved(photon);
        }
        for (Molecule molecule : new ArrayList<Molecule>(this.activeMolecules)) {
            molecule.stepInTime(d);
        }
    }

    public void setPhotonTarget(PhotonTarget photonTarget) {
        if (this.photonTarget != photonTarget) {
            if (photonTarget == PhotonTarget.CONFIGURABLE_ATMOSPHERE || this.photonTarget == PhotonTarget.CONFIGURABLE_ATMOSPHERE) {
                this.setPhotonEmissionPeriod(Double.POSITIVE_INFINITY);
                this.removeAllPhotons();
            }
            this.photonTarget = photonTarget;
            this.removeOldTarget();
            switch (photonTarget) {
                case SINGLE_CO_MOLECULE: {
                    CO cO = new CO(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(cO);
                    break;
                }
                case SINGLE_CO2_MOLECULE: {
                    CO2 cO2 = new CO2(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(cO2);
                    break;
                }
                case SINGLE_H2O_MOLECULE: {
                    H2O h2O = new H2O(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(h2O);
                    break;
                }
                case SINGLE_CH4_MOLECULE: {
                    CH4 cH4 = new CH4(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(cH4);
                    break;
                }
                case SINGLE_N2_MOLECULE: {
                    N2 n2 = new N2(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(n2);
                    break;
                }
                case SINGLE_O2_MOLECULE: {
                    O2 o2 = new O2(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(o2);
                    break;
                }
                case SINGLE_O3_MOLECULE: {
                    O3 o3 = new O3(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(o3);
                    break;
                }
                case SINGLE_NO2_MOLECULE: {
                    NO2 nO2 = new NO2(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(nO2);
                    break;
                }
                case CONFIGURABLE_ATMOSPHERE: {
                    this.activeMolecules.addAll(this.configurableAtmosphereMolecules);
                    break;
                }
                default: {
                    System.err.println(this.getClass().getName() + " - Error: Unhandled photon target.");
                }
            }
            this.finishAddingMolecules();
        }
    }

    private void removeAllPhotons() {
        ArrayList<Photon> arrayList = new ArrayList<Photon>(this.photons);
        this.photons.clear();
        for (Photon photon : arrayList) {
            this.photons.remove(photon);
            this.notifyPhotonRemoved(photon);
        }
    }

    public PhotonTarget getPhotonTarget() {
        return this.photonTarget;
    }

    public Point2D getPhotonEmissionLocation() {
        return PHOTON_EMISSION_LOCATION;
    }

    public Rectangle2D getContainmentAreaRect() {
        return CONTAINMENT_AREA_RECT;
    }

    public ArrayList<Molecule> getMolecules() {
        return new ArrayList<Molecule>(this.activeMolecules);
    }

    public double getPhotonEmissionPeriod() {
        return this.photonEmissionPeriodTarget;
    }

    public void setPhotonEmissionPeriod(double d) {
        assert (d >= 0.0);
        if (this.photonEmissionPeriodTarget != d) {
            if (this.photonEmissionPeriodTarget == Double.POSITIVE_INFINITY && d != Double.POSITIVE_INFINITY) {
                this.photonEmissionCountdownTimer = 300.0;
            } else if (d < this.photonEmissionCountdownTimer) {
                this.photonEmissionCountdownTimer = d;
            } else if (d == Double.POSITIVE_INFINITY) {
                this.photonEmissionCountdownTimer = d;
            }
            this.photonEmissionPeriodTarget = d;
            this.notifyPhotonEmissionPeriodChanged();
        }
    }

    public void emitPhoton() {
        Photon photon = new Photon(this.photonWavelength);
        photon.setLocation(PHOTON_EMISSION_LOCATION.getX(), PHOTON_EMISSION_LOCATION.getY());
        double d = 0.0;
        if (this.photonTarget == PhotonTarget.CONFIGURABLE_ATMOSPHERE) {
            d = RAND.nextDouble() * 1.5707963267948966 / 2.0;
            if (this.previousEmissionAngle > 0.0) {
                d = -d;
            }
            this.previousEmissionAngle = d;
        }
        photon.setVelocity((float)(2.0 * Math.cos(d)), (float)(2.0 * Math.sin(d)));
        this.photons.add(photon);
        this.notifyPhotonAdded(photon);
    }

    public void setEmittedPhotonWavelength(double d) {
        if (this.photonWavelength != d) {
            this.photonWavelength = d;
            this.notifyEmittedPhotonWavelengthChanged();
        }
    }

    public double getEmittedPhotonWavelength() {
        return this.photonWavelength;
    }

    public int getConfigurableAtmosphereGasLevel(Class<? extends Molecule> clazz) {
        int n = 0;
        for (Molecule molecule : this.configurableAtmosphereMolecules) {
            if (molecule.getClass() != clazz) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public void setConfigurableAtmosphereGasLevel(Class<? extends Molecule> clazz, int n) {
        assert (n >= 0);
        if (n < 0) {
            System.err.println(this.getClass().getName() + " - Error: Invalid target quantity for gas level.");
            return;
        }
        if (n > MAX_ATMOSPHERE_CONCENTRATIONS.get(clazz)) {
            System.err.println(this.getClass().getName() + " - Error: Target quantity of " + n + "is out of range, limiting to " + MAX_ATMOSPHERE_CONCENTRATIONS.get(clazz));
            n = MAX_ATMOSPHERE_CONCENTRATIONS.get(clazz);
        }
        int n2 = 0;
        for (Molecule object : this.configurableAtmosphereMolecules) {
            if (object.getClass() != clazz) continue;
            ++n2;
        }
        int n3 = n - n2;
        if (n3 > 0) {
            void var5_8;
            boolean i = false;
            while (var5_8 < n3) {
                Molecule molecule = Molecule.createMolecule(clazz);
                molecule.setCenterOfGravityPos(this.findLocationInAtmosphereForMolecule(molecule));
                this.configurableAtmosphereMolecules.add(molecule);
                molecule.addListener(this.moleculePhotonEmissionListener);
                ++var5_8;
            }
        } else if (n3 < 0) {
            ArrayList<Molecule> arrayList = new ArrayList<Molecule>();
            for (Molecule molecule : this.configurableAtmosphereMolecules) {
                if (molecule.getClass() != clazz) continue;
                arrayList.add(molecule);
                if (arrayList.size() < Math.abs(n3)) continue;
                break;
            }
            this.configurableAtmosphereMolecules.removeAll(arrayList);
        } else if (n != 0) {
            System.err.println(this.getClass().getName() + " - Warning: Ignoring call to set molecule levels to current level.");
        }
        if (n3 != 0) {
            this.notifyConfigurableAtmospherCompositionChanged();
        }
        if (this.photonTarget == PhotonTarget.CONFIGURABLE_ATMOSPHERE) {
            this.syncConfigAtmosphereToActiveMolecules();
        }
    }

    public int getConfigurableAtmosphereMaxLevel(Class<? extends Molecule> clazz) {
        if (MAX_ATMOSPHERE_CONCENTRATIONS.containsKey(clazz)) {
            return MAX_ATMOSPHERE_CONCENTRATIONS.get(clazz);
        }
        return 0;
    }

    public void syncConfigAtmosphereToActiveMolecules() {
        for (Molecule object2 : this.configurableAtmosphereMolecules) {
            if (this.activeMolecules.contains(object2)) continue;
            this.activeMolecules.add(object2);
            this.notifyMoleculeAdded(object2);
        }
        ArrayList arrayList = new ArrayList();
        for (Molecule molecule : this.activeMolecules) {
            if (this.configurableAtmosphereMolecules.contains(molecule)) continue;
            arrayList.add(molecule);
        }
        this.activeMolecules.removeAll(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Molecule molecule;
            molecule = (Molecule)iterator.next();
            this.notifyMoleculeRemoved(molecule);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(Listener.class, listener);
    }

    private Point2D findLocationInAtmosphereForMolecule(Molecule molecule) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        double d = 20.0 + molecule.getBoundingRect().getWidth() / 2.0;
        double d2 = CONTAINMENT_AREA_RECT.getMinX() + d;
        double d3 = CONTAINMENT_AREA_RECT.getWidth() - 2.0 * d;
        double d4 = 20.0 + molecule.getBoundingRect().getHeight() / 2.0;
        double d5 = CONTAINMENT_AREA_RECT.getMinY() + d4;
        double d6 = CONTAINMENT_AREA_RECT.getHeight() - 2.0 * d4;
        for (int i = 0; i < 20; ++i) {
            double d7 = d5 + RAND.nextDouble() * d6;
            double d8 = Math.abs(d7 - this.getContainmentAreaRect().getCenterY()) < 400.0 ? d2 + 300.0 + RAND.nextDouble() * (d3 - 300.0) : d2 + RAND.nextDouble() * d3;
            arrayList.add(new Point2D.Double(d8, d7));
        }
        final double d9 = molecule.getBoundingRect().getWidth();
        final double d10 = molecule.getBoundingRect().getHeight();
        Collections.sort(arrayList, new Comparator<Point2D>(){

            @Override
            public int compare(Point2D point2D, Point2D point2D2) {
                return Double.compare(PhotonAbsorptionModel.this.getOverlapWithOtherMolecules(point2D, d9, d10), PhotonAbsorptionModel.this.getOverlapWithOtherMolecules(point2D2, d9, d10));
            }
        });
        Point2D point2D = (Point2D)arrayList.get(0);
        if (point2D.getX() + d9 / 2.0 > CONTAINMENT_AREA_RECT.getMaxX()) {
            System.out.println("Whoa! " + point2D);
        }
        return (Point2D)arrayList.get(0);
    }

    private Rectangle2D createRectangleFromPoint(Point2D point2D, double d, double d2) {
        return new Rectangle2D.Double(point2D.getX() - d / 2.0, point2D.getY() - d2 / 2.0, d, d2);
    }

    private double getMinDistanceToOtherMolecules(Point2D point2D) {
        double d = Double.POSITIVE_INFINITY;
        for (Molecule molecule : this.configurableAtmosphereMolecules) {
            if (!(molecule.getCenterOfGravityPos().distance(point2D) < d)) continue;
            d = molecule.getCenterOfGravityPos().distance(point2D);
        }
        return d;
    }

    private double getOverlapWithOtherMolecules(Point2D point2D, double d, double d2) {
        double d3 = 0.0;
        Rectangle2D rectangle2D = this.createRectangleFromPoint(point2D, d, d2);
        for (Molecule molecule : this.configurableAtmosphereMolecules) {
            d3 += Math.max(molecule.getBoundingRect().createIntersection(rectangle2D).getWidth(), 0.0) * Math.max(molecule.getBoundingRect().createIntersection(rectangle2D).getHeight(), 0.0);
        }
        if (d3 == 0.0) {
            d3 = -this.getMinDistanceToOtherMolecules(point2D);
        }
        return d3;
    }

    private void resetConfigurableAtmosphere() {
        assert (this.photonTarget != PhotonTarget.CONFIGURABLE_ATMOSPHERE);
    }

    private void notifyPhotonAdded(Photon photon) {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.photonAdded(photon);
        }
    }

    private void notifyPhotonRemoved(Photon photon) {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.photonRemoved(photon);
        }
    }

    private void notifyMoleculeAdded(Molecule molecule) {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.moleculeAdded(molecule);
        }
    }

    private void notifyMoleculeRemoved(Molecule molecule) {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.moleculeRemoved(molecule);
        }
    }

    private void notifyEmittedPhotonWavelengthChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.emittedPhotonWavelengthChanged();
        }
    }

    private void notifyPhotonEmissionPeriodChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.photonEmissionPeriodChanged();
        }
    }

    private void notifyPhotonTargetChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.photonTargetChanged();
        }
    }

    private void notifyConfigurableAtmospherCompositionChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.configurableAtmosphereCompositionChanged();
        }
    }

    private void notifyModelReset() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.modelReset();
        }
    }

    static {
        int n = 8;
        double d = 3100.0 / (double)(n + 1);
        int n2 = 8;
        double d2 = 3100.0 / (double)(n2 + 1);
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= n2; ++j) {
                GRID_POINTS.add(new Point2D.Double((double)i * d + CONTAINMENT_AREA_RECT.getMinX(), (double)j * d2 + CONTAINMENT_AREA_RECT.getMinY()));
            }
        }
    }

    public static class Adapter
    implements Listener {
        public void photonAdded(Photon photon) {
        }

        public void emittedPhotonWavelengthChanged() {
        }

        public void photonRemoved(Photon photon) {
        }

        public void photonTargetChanged() {
        }

        public void moleculeAdded(Molecule molecule) {
        }

        public void moleculeRemoved(Molecule molecule) {
        }

        public void configurableAtmosphereCompositionChanged() {
        }

        public void photonEmissionPeriodChanged() {
        }

        public void modelReset() {
        }
    }

    public static interface Listener
    extends EventListener {
        public void photonAdded(Photon var1);

        public void photonRemoved(Photon var1);

        public void moleculeAdded(Molecule var1);

        public void moleculeRemoved(Molecule var1);

        public void emittedPhotonWavelengthChanged();

        public void photonTargetChanged();

        public void photonEmissionPeriodChanged();

        public void configurableAtmosphereCompositionChanged();

        public void modelReset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PhotonTarget
    extends Enum<PhotonTarget> {
        public static final /* enum */ PhotonTarget SINGLE_CO_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_CO2_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_H2O_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_CH4_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_N2O_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_N2_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_NO2_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_O2_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_O3_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget CONFIGURABLE_ATMOSPHERE = new PhotonTarget();
        private static final /* synthetic */ PhotonTarget[] $VALUES;

        public static PhotonTarget[] values() {
            return (PhotonTarget[])$VALUES.clone();
        }

        static {
            $VALUES = new PhotonTarget[]{SINGLE_CO_MOLECULE, SINGLE_CO2_MOLECULE, SINGLE_H2O_MOLECULE, SINGLE_CH4_MOLECULE, SINGLE_N2O_MOLECULE, SINGLE_N2_MOLECULE, SINGLE_NO2_MOLECULE, SINGLE_O2_MOLECULE, SINGLE_O3_MOLECULE, CONFIGURABLE_ATMOSPHERE};
        }
    }
}

