/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.model.molecules;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionStrategy;
import edu.colorado.phet.common.photonabsorption.model.atoms.AtomicBond;
import edu.colorado.phet.common.photonabsorption.model.atoms.CarbonAtom;
import edu.colorado.phet.common.photonabsorption.model.atoms.OxygenAtom;
import java.awt.geom.Point2D;

public class CO
extends Molecule {
    private final CarbonAtom carbonAtom = new CarbonAtom();
    private final OxygenAtom oxygenAtom = new OxygenAtom();
    private final AtomicBond carbonOxygenBond = new AtomicBond(this.carbonAtom, this.oxygenAtom, 3);

    public CO(Point2D point2D) {
        this.addAtom(this.carbonAtom);
        this.addAtom(this.oxygenAtom);
        this.addAtomicBond(this.carbonOxygenBond);
        this.setPhotonAbsorptionStrategy(20.0, new PhotonAbsorptionStrategy.RotationStrategy(this));
        this.setPhotonAbsorptionStrategy(8.5E-7, new PhotonAbsorptionStrategy.VibrationStrategy(this));
        this.initializeAtomOffsets();
        this.setCenterOfGravityPos(point2D);
    }

    public CO() {
        this(new Point2D.Double(0.0, 0.0));
    }

    public void setVibration(double d) {
        super.setVibration(d);
        double d2 = Math.sin(d);
        this.getVibrationAtomOffset(this.carbonAtom).setComponents(20.0 * d2, 0.0);
        this.getVibrationAtomOffset(this.oxygenAtom).setComponents(-20.0 * d2, 0.0);
        this.updateAtomPositions();
    }

    protected void initializeAtomOffsets() {
        this.addInitialAtomCogOffset(this.carbonAtom, new Vector2D(-85.0, 0.0));
        this.addInitialAtomCogOffset(this.oxygenAtom, new Vector2D(85.0, 0.0));
        this.updateAtomPositions();
    }
}

