/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.model.molecules;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionStrategy;
import edu.colorado.phet.common.photonabsorption.model.atoms.AtomicBond;
import edu.colorado.phet.common.photonabsorption.model.atoms.HydrogenAtom;
import edu.colorado.phet.common.photonabsorption.model.atoms.OxygenAtom;
import java.awt.geom.Point2D;

public class H2O
extends Molecule {
    private static final double INITIAL_MOLECULE_HEIGHT = 130.0 * Math.cos(0.9512044423369095);
    private static final double INITIAL_OXYGEN_VERTICAL_OFFSET = INITIAL_MOLECULE_HEIGHT * 0.14274498608236386;
    private static final double INITIAL_HYDROGEN_VERTICAL_OFFSET = -(INITIAL_MOLECULE_HEIGHT - INITIAL_OXYGEN_VERTICAL_OFFSET);
    private static final double INITIAL_HYDROGEN_HORIZONTAL_OFFSET = 130.0 * Math.sin(0.9512044423369095);
    private final OxygenAtom oxygenAtom = new OxygenAtom();
    private final HydrogenAtom hydrogenAtom1 = new HydrogenAtom();
    private final HydrogenAtom hydrogenAtom2 = new HydrogenAtom();
    private final AtomicBond oxygenHydrogenBond1 = new AtomicBond(this.oxygenAtom, this.hydrogenAtom1, 1);
    private final AtomicBond oxygenHydrogenBond2 = new AtomicBond(this.oxygenAtom, this.hydrogenAtom2, 1);

    public H2O(Point2D point2D) {
        this.addAtom(this.oxygenAtom);
        this.addAtom(this.hydrogenAtom1);
        this.addAtom(this.hydrogenAtom2);
        this.addAtomicBond(this.oxygenHydrogenBond1);
        this.addAtomicBond(this.oxygenHydrogenBond2);
        this.setPhotonAbsorptionStrategy(20.0, new PhotonAbsorptionStrategy.RotationStrategy(this));
        this.setPhotonAbsorptionStrategy(8.5E-7, new PhotonAbsorptionStrategy.VibrationStrategy(this));
        this.initializeAtomOffsets();
        this.setCenterOfGravityPos(point2D);
    }

    public H2O() {
        this(new Point2D.Double(0.0, 0.0));
    }

    protected void initializeAtomOffsets() {
        this.addInitialAtomCogOffset(this.oxygenAtom, new Vector2D(0.0, INITIAL_OXYGEN_VERTICAL_OFFSET));
        this.addInitialAtomCogOffset(this.hydrogenAtom1, new Vector2D(INITIAL_HYDROGEN_HORIZONTAL_OFFSET, INITIAL_HYDROGEN_VERTICAL_OFFSET));
        this.addInitialAtomCogOffset(this.hydrogenAtom2, new Vector2D(-INITIAL_HYDROGEN_HORIZONTAL_OFFSET, INITIAL_HYDROGEN_VERTICAL_OFFSET));
        this.updateAtomPositions();
    }

    public void setVibration(double d) {
        super.setVibration(d);
        double d2 = Math.sin(d);
        double d3 = 3.0;
        double d4 = 18.0;
        this.addInitialAtomCogOffset(this.oxygenAtom, new Vector2D(0.0, INITIAL_OXYGEN_VERTICAL_OFFSET - d2 * d3));
        this.addInitialAtomCogOffset(this.hydrogenAtom1, new Vector2D(INITIAL_HYDROGEN_HORIZONTAL_OFFSET + d2 * d4, INITIAL_HYDROGEN_VERTICAL_OFFSET + d2 * d4));
        this.addInitialAtomCogOffset(this.hydrogenAtom2, new Vector2D(-INITIAL_HYDROGEN_HORIZONTAL_OFFSET - d2 * d4, INITIAL_HYDROGEN_VERTICAL_OFFSET + d2 * d4));
        this.updateAtomPositions();
    }
}

