/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.photonabsorption.model.atoms.Atom;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class AtomNode
extends PNode {
    private final Atom atom;
    private final ModelViewTransform2D mvt;
    private PhetPPath highlightNode;

    public AtomNode(Atom atom, ModelViewTransform2D modelViewTransform2D) {
        this.atom = atom;
        this.mvt = modelViewTransform2D;
        double d = modelViewTransform2D.modelToViewDifferentialXDouble(atom.getRadius());
        Color color = Color.WHITE;
        Color color2 = atom.getRepresentationColor() != Color.WHITE ? ColorUtils.darkerColor(atom.getRepresentationColor(), 0.1) : Color.LIGHT_GRAY;
        int n = 13;
        RoundGradientPaint roundGradientPaint = new RoundGradientPaint(-d / 2.0, -d / 2.0, color, new Point2D.Double(d / 2.0, d / 2.0), color2);
        RoundGradientPaint roundGradientPaint2 = new RoundGradientPaint(0.0, 0.0, Color.yellow, new Point2D.Double(d + (double)n, d + (double)n), new Color(0, 0, 0, 0));
        this.highlightNode = new PhetPPath((Shape)new Ellipse2D.Double(-d - (double)n, -d - (double)n, d * 2.0 + (double)(n * 2), d * 2.0 + (double)(n * 2)), (Paint)roundGradientPaint2);
        PhetPPath phetPPath = new PhetPPath((Shape)new Ellipse2D.Double(-d, -d, d * 2.0, d * 2.0), (Paint)roundGradientPaint);
        this.addChild(this.highlightNode);
        this.addChild(phetPPath);
        atom.addObserver(new SimpleObserver(){

            public void update() {
                AtomNode.this.updatePosition();
            }
        });
        this.updatePosition();
    }

    private void updatePosition() {
        this.setOffset(this.mvt.modelToViewDouble(this.atom.getPositionRef()));
    }

    public void setHighlighted(boolean bl) {
        this.highlightNode.setVisible(bl);
    }
}

