/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.mediabuttons;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;
import java.util.ArrayList;

public class AbstractMediaButton
extends PNode {
    private PImage buttonImageNode;
    private int buttonHeight;
    private boolean enabled = true;
    private boolean mousePressed = false;
    private boolean mouseEntered = false;
    private final Image normalImage;
    private final BufferedImage disabledImage;
    private final Image mouseEnteredImage;
    private final Image armedImage;
    private CursorHandler cursorHandler;
    private ArrayList listeners = new ArrayList();

    public AbstractMediaButton(int n) {
        this.buttonHeight = n;
        this.normalImage = this.createImage();
        this.disabledImage = new MyRescaleOp(this.getDisabledImageRescaleOpScale(), -100.0).filter(this.createImage(), null);
        this.mouseEnteredImage = new MyRescaleOp(1.2, 0.0).filter(this.createImage(), null);
        this.armedImage = this.createImage("button-template_pressed.png");
        this.buttonImageNode = new PImage(this.normalImage);
        this.addChild(this.buttonImageNode);
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseEntered(PInputEvent pInputEvent) {
                AbstractMediaButton.this.mouseEntered = true;
                AbstractMediaButton.this.updateImage();
            }

            public void mouseExited(PInputEvent pInputEvent) {
                AbstractMediaButton.this.mouseEntered = false;
                AbstractMediaButton.this.updateImage();
            }

            public void mousePressed(PInputEvent pInputEvent) {
                AbstractMediaButton.this.mousePressed = true;
                AbstractMediaButton.this.updateImage();
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                AbstractMediaButton.this.mousePressed = false;
                AbstractMediaButton.this.updateImage();
            }
        });
        this.cursorHandler = new CursorHandler();
        this.addInputEventListener(this.cursorHandler);
        this.addListener(new Listener(){

            public void enabledChanged() {
                if (AbstractMediaButton.this.isEnabled()) {
                    AbstractMediaButton.this.addInputEventListener(AbstractMediaButton.this.cursorHandler);
                } else {
                    AbstractMediaButton.this.removeInputEventListener(AbstractMediaButton.this.cursorHandler);
                }
            }
        });
    }

    protected double getDisabledImageRescaleOpScale() {
        return 0.5;
    }

    private void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.updateImage();
            this.notifyEnabledChanged();
        }
    }

    private void notifyEnabledChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.enabledChanged();
        }
    }

    protected void updateImage() {
        if (!this.enabled) {
            this.buttonImageNode.setImage(this.disabledImage);
        } else if (!this.mouseEntered) {
            this.buttonImageNode.setImage(this.normalImage);
        } else if (this.mousePressed) {
            this.buttonImageNode.setImage(this.armedImage);
        } else {
            this.buttonImageNode.setImage(this.mouseEnteredImage);
        }
    }

    protected BufferedImage createImage() {
        return this.createImage("button-template.png");
    }

    private BufferedImage createImage(String string) {
        BufferedImage bufferedImage = new PhetResources("piccolo-phet").getImage(string);
        return BufferedImageUtils.multiScaleToHeight(bufferedImage, this.buttonHeight);
    }

    public PDimension getButtonDimension() {
        return new PDimension(this.buttonImageNode.getFullBounds().width, this.buttonImageNode.getFullBounds().height);
    }

    public static interface Listener {
        public void enabledChanged();
    }

    static class MyRescaleOp
    extends LookupOp {
        public MyRescaleOp(final double d, final double d2) {
            super(new LookupTable(0, 4){

                public int[] lookupPixel(int[] nArray, int[] nArray2) {
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray2[i] = (int)MathUtil.clamp(0.0, (double)nArray[i] * d + d2, 255.0);
                    }
                    return nArray2;
                }
            }, null);
        }
    }
}

