/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.mediabuttons;

import edu.colorado.phet.common.piccolophet.event.ButtonEventHandler;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.ButtonIconSet;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.IconButton;
import java.util.ArrayList;

public class PlayPauseButton
extends IconButton {
    private boolean playing;
    private ButtonIconSet buttonIconSet;
    private ArrayList listeners = new ArrayList();

    public PlayPauseButton(int n) {
        super(n);
        this.buttonIconSet = new ButtonIconSet(n, n);
        ButtonEventHandler buttonEventHandler = new ButtonEventHandler();
        this.addInputEventListener(buttonEventHandler);
        buttonEventHandler.addButtonEventListener(new ButtonEventHandler.ButtonEventAdapter(){

            public void fire() {
                if (PlayPauseButton.this.isEnabled()) {
                    PlayPauseButton.this.setPlaying(!PlayPauseButton.this.isPlaying());
                    PlayPauseButton.this.update();
                    PlayPauseButton.this.notifyListeners();
                }
            }
        });
        this.setPlaying(true);
    }

    public void setPlaying(boolean bl) {
        this.playing = bl;
        this.update();
        this.updateImage();
    }

    public boolean isPlaying() {
        return this.playing;
    }

    private void update() {
        this.setIconPath(this.isPlaying() ? this.buttonIconSet.createPauseIconShape() : this.buttonIconSet.createPlayIconShape());
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).playbackStateChanged();
        }
    }

    public static interface Listener {
        public void playbackStateChanged();
    }
}

