/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.greenhouse.GlassPaneModule;
import edu.colorado.phet.greenhouse.GreenhouseConfig;
import edu.colorado.phet.greenhouse.GreenhouseModule;
import edu.colorado.phet.greenhouse.PhotonAbsorptionModule;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;

public class GreenhouseApplication
extends PiccoloPhetApplication {
    private final PhotonAbsorptionModule photonAbsorptionModule;

    public GreenhouseApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        PhetFrame phetFrame = this.getPhetFrame();
        this.addModule(new GreenhouseModule());
        this.addModule(new GlassPaneModule());
        this.photonAbsorptionModule = new PhotonAbsorptionModule(phetFrame);
        this.addModule(this.photonAbsorptionModule);
        JMenu jMenu = phetFrame.getDeveloperMenu();
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Photon Absorption Controls");
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GreenhouseApplication.this.photonAbsorptionModule.setPhotonAbsorptionParamsDlgVisible(jCheckBoxMenuItem.isSelected());
            }
        });
        GreenhouseApplication.paintContentImmediately();
        this.getPhetFrame().addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                GreenhouseApplication.paintContentImmediately();
            }

            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
    }

    public static void paintContentImmediately() {
        Container container = PhetApplication.getInstance().getPhetFrame().getContentPane();
        if (container instanceof JComponent) {
            JComponent jComponent = (JComponent)container;
            jComponent.paintImmediately(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new GreenhouseApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "greenhouse", "greenhouse");
        phetApplicationConfig.setLookAndFeel(new GreenhouseLookAndFeel());
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }

    private static class GreenhouseLookAndFeel
    extends PhetLookAndFeel {
        public GreenhouseLookAndFeel() {
            this.setBackgroundColor(GreenhouseConfig.PANEL_BACKGROUND_COLOR);
            this.setTitledBorderFont(new PhetFont(0, 12));
        }
    }
}

