/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionModel;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.greenhouse.GreenhouseResources;
import edu.colorado.phet.greenhouse.controlpanel.PhotonAbsorptionControlPanel;
import edu.colorado.phet.greenhouse.developer.PhotonAbsorptionParamsDlg;
import edu.colorado.phet.greenhouse.view.PhotonAbsorptionCanvas;
import java.awt.Frame;
import javax.swing.JComponent;

public class PhotonAbsorptionModule
extends PiccoloModule {
    private final PhotonAbsorptionModel model;
    private final PhetPCanvas canvas;
    private final PhotonAbsorptionControlPanel controlPanel;
    private PiccoloClockControlPanel clockControlPanel;
    private PhotonAbsorptionParamsDlg photonAbsorptionParamsDlg;
    private boolean photonAbsorptionParamsDlgVisible;

    public PhotonAbsorptionModule(Frame frame) {
        super(GreenhouseResources.getString("ModuleTitle.PhotonAbsorptionModule"), new ConstantDtClock(40, 40.0));
        this.setLogoPanel(null);
        this.model = new PhotonAbsorptionModel((ConstantDtClock)this.getClock());
        this.canvas = new PhotonAbsorptionCanvas(this.model, true);
        this.setSimulationPanel(this.canvas);
        this.controlPanel = new PhotonAbsorptionControlPanel(this, this.model);
        this.setControlPanel(this.controlPanel);
        if (this.hasHelp()) {
            // empty if block
        }
        if (PhetApplication.getInstance().isDeveloperControlsEnabled()) {
            this.photonAbsorptionParamsDlg = new PhotonAbsorptionParamsDlg(frame, this.model);
            this.photonAbsorptionParamsDlgVisible = false;
        }
        this.reset();
    }

    protected JComponent createClockControlPanel(IClock iClock) {
        this.clockControlPanel = new PiccoloClockControlPanel(iClock);
        return this.clockControlPanel;
    }

    public void reset() {
        this.model.reset();
    }

    public void activate() {
        super.activate();
        if (this.photonAbsorptionParamsDlg != null && this.photonAbsorptionParamsDlgVisible) {
            this.photonAbsorptionParamsDlg.setVisible(true);
        }
    }

    public void deactivate() {
        if (this.photonAbsorptionParamsDlg != null) {
            this.photonAbsorptionParamsDlg.setVisible(false);
        }
        super.deactivate();
    }

    public void setPhotonAbsorptionParamsDlgVisible(boolean bl) {
        this.photonAbsorptionParamsDlgVisible = bl;
        if (this.isActive() && this.photonAbsorptionParamsDlg != null) {
            this.photonAbsorptionParamsDlg.setVisible(bl);
        }
    }
}

