/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.common.graphics;

import edu.colorado.phet.greenhouse.common.graphics.Graphic;
import edu.colorado.phet.greenhouse.common.graphics.InteractiveGraphic;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class CompositeGraphic
implements InteractiveGraphic {
    private TreeMap graphicLayers = new TreeMap();
    private InteractiveGraphic selectedGraphic;
    private InteractiveGraphic mouseEnteredGraphic;
    private List inorder = new ArrayList();

    public void paint(Graphics2D graphics2D) {
        AffineTransform affineTransform = graphics2D.getTransform();
        for (int i = 0; i < this.inorder.size(); ++i) {
            Graphic graphic = (Graphic)this.inorder.get(i);
            graphic.paint(graphics2D);
        }
        graphics2D.setTransform(affineTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGraphic(Graphic graphic, double d) {
        Double d2 = new Double(d);
        ArrayList<Graphic> arrayList = (ArrayList<Graphic>)this.graphicLayers.get(d2);
        if (arrayList == null) {
            arrayList = new ArrayList<Graphic>(10);
            this.graphicLayers.put(d2, arrayList);
        }
        TreeMap treeMap = this.graphicLayers;
        synchronized (treeMap) {
            arrayList.add(graphic);
        }
        this.recreateList();
    }

    private void recreateList() {
        this.inorder = this.getElementsInOrder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGraphic(Graphic graphic) {
        TreeMap treeMap = this.graphicLayers;
        synchronized (treeMap) {
            for (Collection collection : this.graphicLayers.values()) {
                ArrayList<Graphic> arrayList = new ArrayList<Graphic>();
                for (Graphic graphic2 : collection) {
                    if (graphic2 != graphic) continue;
                    arrayList.add(graphic2);
                }
                collection.removeAll(arrayList);
            }
        }
        this.recreateList();
    }

    private List getElementsInOrder() {
        ArrayList arrayList = new ArrayList();
        Collection collection = this.graphicLayers.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll((ArrayList)iterator.next());
        }
        return arrayList;
    }

    public void mousePressed(MouseEvent mouseEvent, Point2D.Double double_) {
        if (this.selectedGraphic == null) {
            this.selectedGraphic = this.determineMouseHandler(mouseEvent, double_);
            if (this.selectedGraphic != null) {
                this.selectedGraphic.mousePressed(mouseEvent, double_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InteractiveGraphic determineMouseHandler(MouseEvent mouseEvent, Point2D.Double double_) {
        InteractiveGraphic interactiveGraphic = null;
        TreeMap treeMap = this.graphicLayers;
        synchronized (treeMap) {
            List list = this.getElementsInOrder();
            for (int i = list.size() - 1; i >= 0; --i) {
                Graphic graphic = (Graphic)list.get(i);
                if (!(graphic instanceof InteractiveGraphic) || !((InteractiveGraphic)graphic).canHandleMousePress(mouseEvent, double_)) continue;
                interactiveGraphic = (InteractiveGraphic)graphic;
                if (!(interactiveGraphic instanceof CompositeGraphic)) break;
                interactiveGraphic = ((CompositeGraphic)interactiveGraphic).determineMouseHandler(mouseEvent, double_);
                break;
            }
        }
        return interactiveGraphic;
    }

    public void mouseDragged(MouseEvent mouseEvent, Point2D.Double double_) {
        if (this.selectedGraphic != null) {
            this.selectedGraphic.mouseDragged(mouseEvent, double_);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent, Point2D.Double double_) {
        if (this.selectedGraphic != null) {
            this.selectedGraphic.mouseReleased(mouseEvent, double_);
        }
        this.selectedGraphic = null;
    }

    public void mouseEntered(MouseEvent mouseEvent, Point2D.Double double_) {
        InteractiveGraphic interactiveGraphic = this.determineMouseHandler(mouseEvent, double_);
        if (interactiveGraphic != null && interactiveGraphic != this.mouseEnteredGraphic) {
            this.mouseEnteredGraphic = interactiveGraphic;
            this.mouseEnteredGraphic.mouseEntered(mouseEvent, double_);
        }
    }

    public void mouseExited(MouseEvent mouseEvent, Point2D.Double double_) {
        if (this.mouseEnteredGraphic != null) {
            this.mouseEnteredGraphic.mouseExited(mouseEvent, double_);
            this.mouseEnteredGraphic = null;
        }
    }

    public boolean canHandleMousePress(MouseEvent mouseEvent, Point2D.Double double_) {
        return this.determineMouseHandler(mouseEvent, double_) != null;
    }

    public void mouseMoved(MouseEvent mouseEvent, Point2D.Double double_) {
        InteractiveGraphic interactiveGraphic = this.determineMouseHandler(mouseEvent, double_);
        if (this.mouseEnteredGraphic != null && interactiveGraphic == null) {
            this.mouseEnteredGraphic.mouseExited(mouseEvent, double_);
            this.mouseEnteredGraphic = null;
        } else if (this.mouseEnteredGraphic != null && interactiveGraphic != null && this.mouseEnteredGraphic != interactiveGraphic) {
            this.mouseEnteredGraphic.mouseExited(mouseEvent, double_);
            this.mouseEnteredGraphic = interactiveGraphic;
            this.mouseEnteredGraphic.mouseEntered(mouseEvent, double_);
        } else if (interactiveGraphic != null && this.mouseEnteredGraphic == null) {
            this.mouseEnteredGraphic = interactiveGraphic;
            this.mouseEnteredGraphic.mouseEntered(mouseEvent, double_);
        }
    }
}

