/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.developer;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionModel;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionStrategy;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PhotonAbsorptionParamsDlg
extends PaintImmediateDialog {
    public PhotonAbsorptionParamsDlg(Frame frame, final PhotonAbsorptionModel photonAbsorptionModel) {
        super(frame);
        this.setTitle("Params");
        this.setLayout(new GridLayout(3, 2));
        this.add(new JLabel("Single Target Photon Emission Frequency", 0));
        final LinearValueControl linearValueControl = new LinearValueControl(0.0, 5.0, "Frequency:", "#.#", "Photons/sec");
        linearValueControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                photonAbsorptionModel.setPhotonEmissionPeriod(1.0 / linearValueControl.getValue() * 1000.0);
            }
        });
        linearValueControl.setValue(1.0 / photonAbsorptionModel.getPhotonEmissionPeriod() * 1000.0);
        this.add(linearValueControl);
        this.add(new JLabel("Multi-Target Photon Emission Frequency", 0));
        final LinearValueControl linearValueControl2 = new LinearValueControl(0.0, 5.0, "Frequency:", "#.#", "Photons/sec");
        linearValueControl2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                photonAbsorptionModel.setPhotonEmissionPeriod(1.0 / linearValueControl2.getValue() * 1000.0);
            }
        });
        linearValueControl2.setValue(1.0 / photonAbsorptionModel.getPhotonEmissionPeriod() * 1000.0);
        this.add(linearValueControl2);
        this.add(new JLabel("Absorption Probability", 0));
        final LinearValueControl linearValueControl3 = new LinearValueControl(0.0, 1.0, "Probability", "#.#", null);
        linearValueControl3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PhotonAbsorptionStrategy.photonAbsorptionProbability.set(linearValueControl3.getValue());
            }
        });
        linearValueControl3.setValue(PhotonAbsorptionStrategy.photonAbsorptionProbability.get());
        this.add(linearValueControl3);
        this.setDefaultCloseOperation(1);
        this.setLocationRelativeTo(null);
        this.pack();
    }
}

