/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.model;

import edu.colorado.phet.greenhouse.GreenhouseConfig;
import edu.colorado.phet.greenhouse.model.BasicPhotonAbsorber;
import edu.colorado.phet.greenhouse.model.CircularPhotonEmitter;
import edu.colorado.phet.greenhouse.model.Disk;
import edu.colorado.phet.greenhouse.model.Photon;
import edu.colorado.phet.greenhouse.model.PhotonAbsorber;
import edu.colorado.phet.greenhouse.model.PhotonEmitter;
import edu.colorado.phet.greenhouse.model.ReflectivityAssessor;
import edu.colorado.phet.greenhouse.model.TemperatureReporter;
import edu.colorado.phet.greenhouse.util.ModelViewTx1D;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Earth
extends Disk
implements PhotonAbsorber,
PhotonEmitter.Listener<Photon>,
PhotonEmitter,
TemperatureReporter {
    public static double radius = 6370.0;
    private double netEnergy = 0.0;
    double emissivity = GreenhouseConfig.defaultEarthEmissivity;
    private CircularPhotonEmitter photonSource;
    private BasicPhotonAbsorber photonAbsorber;
    private double baseTemperature;
    private double temperature;
    private double[] temperatureHistory = new double[200];
    private ReflectivityAssessor reflectivityAssessor;
    private double timeSinceEmission = 0.0;
    private double[][] jimmyArray;
    private ModelViewTx1D[] txArray;

    public Earth(Point2D.Double double_, double d, double d2) {
        super(double_, radius);
        this.photonSource = new CircularPhotonEmitter(double_, radius, 8.5E-7, d, d2);
        this.photonSource.addListener(this);
        this.photonAbsorber = new BasicPhotonAbsorber();
        this.temperature = 251.0;
        this.baseTemperature = 251.0;
        for (int i = 0; i < this.temperatureHistory.length; ++i) {
            this.temperatureHistory[i] = this.baseTemperature;
        }
    }

    @Override
    public void stepInTime(double d) {
        super.stepInTime(d);
        this.timeSinceEmission += d;
        if (this.timeSinceEmission >= 10.0) {
            this.computeTemperature();
            while (this.netEnergy > 0.0) {
                this.photonSource.notifyListeners(this.photonSource.emitPhoton());
            }
            this.timeSinceEmission = 0.0;
        }
    }

    public void setBaseTemperature(double d) {
        this.baseTemperature = d;
    }

    private void computeTemperature() {
        double d = 0.0;
        for (int i = this.temperatureHistory.length - 2; i >= 0; --i) {
            d += this.temperatureHistory[i];
            this.temperatureHistory[i + 1] = this.temperatureHistory[i];
        }
        this.temperatureHistory[0] = this.baseTemperature - 9.0 + 3.0 * Math.pow(this.netEnergy / 1.3806503E-23, 0.25);
        this.temperature = (d += this.temperatureHistory[0]) / 200.0;
        if (this.jimmyArray != null) {
            this.jimmyTemperature();
        }
    }

    public void setJimmyArray(double[][] dArray) {
        this.jimmyArray = dArray;
        if (dArray != null) {
            this.txArray = new ModelViewTx1D[dArray.length - 1];
            for (int i = 0; i < dArray.length - 1; ++i) {
                ModelViewTx1D modelViewTx1D;
                this.txArray[i] = modelViewTx1D = new ModelViewTx1D(dArray[i][0], dArray[i + 1][0], (int)dArray[i][1], (int)dArray[i + 1][1]);
            }
        }
    }

    private void jimmyTemperature() {
        ModelViewTx1D modelViewTx1D = null;
        for (int i = 0; i < this.jimmyArray.length - 1; ++i) {
            if (!(this.temperature >= this.jimmyArray[i][0]) || !(this.temperature >= this.jimmyArray[i][0])) continue;
            modelViewTx1D = this.txArray[i];
        }
        if (modelViewTx1D == null) {
            throw new RuntimeException("no 1D tx found");
        }
        this.temperature = (int)modelViewTx1D.modelToView(this.temperature);
    }

    @Override
    public double getMass() {
        return Double.MAX_VALUE;
    }

    public void absorbPhoton(Photon photon) {
        this.photonAbsorber.absorbPhoton(photon);
        this.netEnergy += photon.getEnergy();
    }

    public CircularPhotonEmitter getPhotonSource() {
        return this.photonSource;
    }

    public void setEmissivity(double d) {
        this.emissivity = d;
    }

    @Override
    public void photonEmitted(Photon photon) {
        this.netEnergy = Math.max(0.0, this.netEnergy -= photon.getEnergy());
    }

    public void addPhotonEmitterListener(PhotonEmitter.Listener listener) {
        this.addListener(listener);
    }

    public void addPhotonAbsorberListener(PhotonAbsorber.Listener listener) {
        this.addListener(listener);
    }

    public void addListener(PhotonAbsorber.Listener listener) {
        this.photonAbsorber.addListener(listener);
    }

    public void addListener(PhotonEmitter.Listener listener) {
        this.photonSource.addListener(listener);
    }

    public Photon emitPhoton() {
        return this.photonSource.emitPhoton();
    }

    public void setReflectivityAssessor(ReflectivityAssessor reflectivityAssessor) {
        this.reflectivityAssessor = reflectivityAssessor;
    }

    public double getReflectivity(Photon photon) {
        double d = 0.0;
        if (this.reflectivityAssessor != null) {
            d = this.reflectivityAssessor.getReflectivity(photon);
        }
        return d;
    }

    @Override
    public double getTemperature() {
        return this.temperature;
    }

    public void reset() {
        for (int i = 0; i < this.temperatureHistory.length; ++i) {
            this.temperatureHistory[i] = this.baseTemperature;
        }
        this.netEnergy = 0.0;
    }
}

