/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.model;

import edu.colorado.phet.common.mechanics.Vector3D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.greenhouse.filter.BandpassFilter;
import edu.colorado.phet.greenhouse.filter.Filter1D;
import edu.colorado.phet.greenhouse.filter.IrFilter;
import edu.colorado.phet.greenhouse.filter.ProbablisticPassFilter;
import edu.colorado.phet.greenhouse.model.Body;
import edu.colorado.phet.greenhouse.model.Cloud;
import edu.colorado.phet.greenhouse.model.Photon;
import java.awt.geom.Point2D;

public class PhotonCloudCollisionModel {
    private static Vector2D n = new Vector2D();
    private static Vector2D vRel = new Vector2D();
    private static Vector2D r1 = new Vector2D();
    private static Vector3D nj = new Vector3D();
    private static Vector2D result = new Vector2D();
    private static Filter1D filter = new PhotonPassFilter();
    private static Filter1D visibleLightFilter = new BandpassFilter(3.0E-7, 7.0E-7);
    private static Filter1D irFilter = new IrFilter();

    public static void handle(Photon photon, Cloud cloud) {
        boolean bl = cloud.getBounds().contains(photon.getLocation());
        if (bl && filter.passes(photon.getWavelength())) {
            Vector2D vector2D = PhotonCloudCollisionModel.getNormalAtPoint(photon.getLocation(), cloud);
            if (visibleLightFilter.passes(photon.getWavelength())) {
                PhotonCloudCollisionModel.doCollision(photon, cloud, vector2D, photon.getLocation());
            }
            if (irFilter.absorbs(photon.getWavelength())) {
                PhotonCloudCollisionModel.doScatter(photon);
            }
        }
    }

    private static void doScatter(Photon photon) {
        double d = 0.7853981633974483;
        double d2 = Math.random() * d + 4.71238898038469 - d / 2.0;
        double d3 = Math.random() < 0.5 ? 0.0 : Math.PI;
        double d4 = photon.getVelocity().getMagnitude();
        photon.setVelocity(d4 * (double)((float)Math.cos(d2 += d3)), d4 * (double)((float)Math.sin(d2)));
    }

    private static void doCollision(Body body, Body body2, Vector2D vector2D, Point2D.Double double_) {
        vRel.setComponents(body.getVelocity().getX(), body.getVelocity().getY());
        vRel.subtract(body2.getVelocity());
        if (vRel.dot(vector2D) <= 0.0) {
            r1.setComponents((float)(double_.getX() - body.getLocation().getX()), (float)(double_.getY() - body.getLocation().getY()));
            n.setComponents(vector2D.getX(), vector2D.getY());
            n.normalize();
            Vector3D vector3D = new Vector3D(0.0, 0.0, (float)body.getOmega());
            Vector3D vector3D2 = vector3D.crossProduct(new Vector3D(r1)).add(new Vector3D(body.getVelocity()));
            double d = vector3D2.dot(new Vector3D(n));
            float f = 1.0f;
            double d2 = -d * (double)(1.0f + f);
            Vector3D vector3D3 = new Vector3D(n);
            Vector3D vector3D4 = new Vector3D(r1);
            Vector3D vector3D5 = vector3D4.crossProduct(vector3D3).multiply((float)(1.0 / body.getMomentOfInertia()));
            Vector3D vector3D6 = vector3D5.crossProduct(vector3D5);
            double d3 = vector3D3.dot(vector3D6);
            double d4 = 1.0 / body.getMass() + vector3D3.dot(vector3D4.crossProduct(vector3D3).multiply(1.0f / (float)body.getMomentOfInertia()).crossProduct(vector3D4));
            double d5 = d2 / d4;
            body.getVelocity().add(new Vector2D(n.getX(), n.getY()).scale((float)(d5 / body.getMass())));
            nj.setComponents(n.getX(), n.getY(), 0.0).multiply((float)d5);
            double d6 = body.getOmega() + vector3D4.crossProduct(nj).getZ() / body.getMomentOfInertia();
            body.setOmega(d6);
        }
    }

    private static Vector2D getNormalAtPoint(Point2D point2D, Cloud cloud) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = cloud.getLocation().getX();
        double d4 = cloud.getLocation().getY();
        double d5 = cloud.getWidth() / 2.0;
        double d6 = cloud.getHeight() / 2.0;
        double d7 = Math.acos((d - d3) / d5);
        double d8 = Math.cos(d7);
        double d9 = Math.sin(d7);
        double d10 = Math.sqrt(d6 * d6 * d8 * d8 + d5 * d5 * d9 * d9);
        double d11 = -(d5 * Math.sin(d7) / d10);
        double d12 = d6 * Math.cos(d7) / d10;
        if (d2 < d4) {
            d11 *= -1.0;
        }
        result.setComponents((float)d11, (float)d12);
        return new Vector2D(result.getY(), -result.getX());
    }

    private static class PhotonPassFilter
    extends Filter1D {
        private ProbablisticPassFilter visibleLightFilter = new ProbablisticPassFilter(0.4);

        private PhotonPassFilter() {
        }

        public boolean passes(double d) {
            if (d >= 8.0E-7) {
                return true;
            }
            return this.visibleLightFilter.passes(d);
        }
    }
}

