/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.model;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.greenhouse.filter.IrFilter;
import edu.colorado.phet.greenhouse.model.GlassPane;
import edu.colorado.phet.greenhouse.model.Photon;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class PhotonGlassPaneCollisionModel {
    private static IrFilter irPassFilter = new IrFilter();

    public static void handle(Photon photon, GlassPane glassPane, IClock iClock) {
        if (irPassFilter.absorbs(photon.getWavelength())) {
            double d = iClock.getSimulationTimeChange();
            Point2D.Double double_ = new Point2D.Double(photon.getLocation().getX() - photon.getVelocity().getX() * d, photon.getLocation().getY() - photon.getVelocity().getY() * d);
            Point2D.Double double_2 = photon.getLocation();
            Line2D.Double double_3 = new Line2D.Double(glassPane.getBounds().getX(), glassPane.getBounds().getY() + glassPane.getBounds().getHeight() / 2.0, glassPane.getBounds().getX() + glassPane.getBounds().getWidth(), glassPane.getBounds().getY() + glassPane.getBounds().getHeight() / 2.0);
            boolean bl = double_3.intersectsLine(((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)double_2).getX(), ((Point2D)double_2).getY());
            if (bl) {
                PhotonGlassPaneCollisionModel.doScatter(photon, glassPane);
            }
        }
    }

    private static void doScatter(Photon photon, GlassPane glassPane) {
        double d = 1.5707963267948966;
        double d2 = Math.random() * d + 4.71238898038469 - d / 2.0;
        double d3 = Math.random() < 0.5 ? 0.0 : Math.PI;
        double d4 = photon.getVelocity().getMagnitude();
        Photon photon2 = new Photon(photon.getWavelength(), glassPane);
        photon2.setVelocity(d4 * (double)((float)Math.cos(d2 += d3)), d4 * (double)((float)Math.sin(d2)));
        double d5 = glassPane.getBounds().getY();
        d5 = d2 % (Math.PI * 2) < Math.PI ? glassPane.getBounds().getMaxY() : glassPane.getBounds().getMinY();
        photon2.setLocation(Math.random() * glassPane.getWidth() + glassPane.getBounds().getX(), d5);
        photon.setVelocity(0.0, 0.0);
        glassPane.absorbPhoton(photon);
        glassPane.emitPhoton(photon2);
    }
}

