/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.greenhouse.BaseGreenhouseModule;
import edu.colorado.phet.greenhouse.GreenhouseConfig;
import edu.colorado.phet.greenhouse.model.Photon;
import java.awt.geom.Point2D;
import java.util.Observable;

public class ScatterEvent
extends Observable
implements ModelElement {
    Point2D.Double location;
    private double radius;
    private BaseGreenhouseModule module;

    public ScatterEvent(Photon photon, BaseGreenhouseModule baseGreenhouseModule) {
        this.module = baseGreenhouseModule;
        this.location = new Point2D.Double(photon.getLocation().x, photon.getLocation().y);
        this.radius = GreenhouseConfig.photonRadius * 1.5;
    }

    public void stepInTime(double d) {
        this.radius -= 0.04;
        if (this.radius <= 0.0) {
            this.module.removeScatterEvent(this);
        }
        this.setChanged();
        this.notifyObservers();
    }
}

