/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.greenhouse.model.TemperatureReporter;
import java.awt.geom.Point2D;
import java.util.Observable;

public class Thermometer
extends Observable
implements ModelElement {
    private TemperatureReporter temperatureReporter;
    private Point2D.Double location = new Point2D.Double();
    private double temperature;
    private double[] temperatureHistory = new double[1];

    public Thermometer(TemperatureReporter temperatureReporter) {
        this.temperatureReporter = temperatureReporter;
    }

    public void stepInTime(double d) {
        double d2 = 0.0;
        for (int i = this.temperatureHistory.length - 2; i >= 0; --i) {
            d2 += this.temperatureHistory[i];
            this.temperatureHistory[i + 1] = this.temperatureHistory[i];
        }
        this.temperatureHistory[0] = this.temperatureReporter.getTemperature();
        this.temperature = d2 / (double)this.temperatureHistory.length;
        this.temperature = (d2 += this.temperatureHistory[0]) / 1.0;
        this.setChanged();
        this.notifyObservers(new Double(this.temperature));
    }

    public Point2D.Double getLocation() {
        return this.location;
    }

    public void setLocation(Point2D.Double double_) {
        this.location = double_;
    }

    public double getTemperature() {
        return this.temperature;
    }
}

