/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.view;

import edu.colorado.phet.greenhouse.common.graphics.Graphic;
import edu.colorado.phet.greenhouse.model.Cloud;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.util.Random;

public class CloudGraphic
implements Graphic {
    static Random random = new Random();
    private Ellipse2D.Double baseOval = new Ellipse2D.Double();
    private Ellipse2D[] auxillaryOvals = new Ellipse2D[8];
    private Cloud cloud;
    private Paint cloudPaint = new Color(230, 230, 230);

    public CloudGraphic(Cloud cloud) {
        this.cloud = cloud;
        for (int i = 0; i < this.auxillaryOvals.length; ++i) {
            this.auxillaryOvals[i] = new Ellipse2D.Double();
        }
        this.update();
    }

    public void paint(Graphics2D graphics2D) {
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setPaint(this.cloudPaint);
        graphics2D.fill(this.baseOval);
        for (int i = 0; i < this.auxillaryOvals.length; ++i) {
            Ellipse2D ellipse2D = this.auxillaryOvals[i];
            graphics2D.fill(ellipse2D);
        }
        graphics2D.setRenderingHints(renderingHints);
    }

    public void update() {
        this.baseOval = this.cloud.getBounds();
        for (int i = 0; i < this.auxillaryOvals.length; ++i) {
            double d = Math.max(random.nextDouble() * this.baseOval.getHeight(), this.baseOval.getHeight() / 4.0);
            double d2 = Math.max(random.nextDouble() * (this.baseOval.getWidth() / 3.0), d * 8.0);
            double d3 = random.nextDouble() * (this.baseOval.getWidth() / 3.0) * (double)(random.nextBoolean() ? 1 : -1);
            double d4 = this.baseOval.getX() + this.baseOval.getWidth() / 2.0 + d3;
            double d5 = this.baseOval.getY() + (double)(random.nextBoolean() ? 1 : 0) * this.baseOval.getHeight() - d / 2.0;
            this.auxillaryOvals[i].setFrame(d4, d5, d2, d);
        }
    }
}

