/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.view;

import edu.colorado.phet.greenhouse.common.graphics.Graphic;
import edu.colorado.phet.greenhouse.common.graphics.ImageGraphic;
import edu.colorado.phet.greenhouse.model.GlassPane;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public class GlassPaneGraphic
implements Graphic {
    private Rectangle2D.Double graphic;
    private Paint glassPaint = Color.white;
    private float glassAlpha = 0.3f;
    private Stroke glassStroke = new BasicStroke(0.01f);

    public GlassPaneGraphic(GlassPane glassPane, ImageGraphic imageGraphic, Rectangle2D rectangle2D) {
        this.graphic = new Rectangle2D.Double(glassPane.getBounds().getMinX(), glassPane.getBounds().getMinY(), glassPane.getWidth(), glassPane.getHeight());
        BufferedImage bufferedImage = imageGraphic.getBufferedImage();
        int n = (int)((double)bufferedImage.getHeight() - glassPane.getBounds().getY() * (double)bufferedImage.getHeight() / rectangle2D.getHeight());
        int n2 = bufferedImage.getRGB(bufferedImage.getWidth() / 2, n);
        ColorModel colorModel = bufferedImage.getColorModel();
        int n3 = (int)(this.glassAlpha * 255.0f);
        int n4 = this.getSrcOver(colorModel.getRed(n2), n3, this.glassAlpha);
        int n5 = this.getSrcOver(colorModel.getGreen(n2), n3, this.glassAlpha);
        int n6 = this.getSrcOver(colorModel.getBlue(n2), n3, this.glassAlpha);
        this.glassPaint = new Color(n4, n5, n6);
    }

    private int getSrcOver(int n, int n2, float f) {
        return (int)((1.0f - f) * (float)n) + n2;
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setPaint(this.glassPaint);
        graphics2D.setStroke(this.glassStroke);
        graphics2D.fill(this.graphic);
    }
}

