/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.view;

import edu.colorado.phet.greenhouse.GreenhouseConfig;
import edu.colorado.phet.greenhouse.GreenhouseResources;
import edu.colorado.phet.greenhouse.common.graphics.Graphic;
import edu.colorado.phet.greenhouse.model.Thermometer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Observable;
import java.util.Observer;

public class ThermometerGraphic
implements Graphic,
Observer {
    private BufferedImage thermometerBody;
    private BufferedImage thermometerBackground;
    private double temperature;
    private Point2D.Double location = new Point2D.Double();
    private Thermometer thermometer;
    private NumberFormat formatter = new DecimalFormat("0");
    private Font temperatureFont = new Font("sanserif", 1, 14);
    private BufferedImage thermometerBI;
    private AffineTransform scaleTx = new AffineTransform();

    public ThermometerGraphic(Thermometer thermometer) {
        thermometer.addObserver(this);
        this.thermometer = thermometer;
        this.thermometerBody = GreenhouseResources.getImage("thermometer-2.png");
        this.thermometerBackground = GreenhouseResources.getImage("thermometer-background-2.png");
        this.thermometerBI = new BufferedImage(this.thermometerBody.getWidth(), this.thermometerBody.getHeight(), 2);
        this.update();
    }

    public void paint(Graphics2D graphics2D) {
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(affineTransform.getTranslateX() / affineTransform.getScaleX(), affineTransform.getTranslateY() / affineTransform.getScaleY());
        if (graphics2D.getTransform().getDeterminant() == 0.0) {
            return;
        }
        try {
            affineTransform2.concatenate(graphics2D.getTransform().createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new RuntimeException(noninvertibleTransformException);
        }
        affineTransform2.translate(0.0, (double)(-this.thermometerBackground.getHeight()) * this.scaleTx.getScaleY());
        affineTransform2.translate(this.location.getX() * affineTransform.getScaleX() - (double)(this.thermometerBackground.getWidth() / 2), this.location.getY() * affineTransform.getScaleY());
        affineTransform2.concatenate(this.scaleTx);
        double d = Math.max(0.0, Math.min((this.temperature - 251.0) / 10.0, 3.5)) * 34.0;
        int n = 20;
        Rectangle2D.Double double_ = new Rectangle2D.Double(n, (double)(this.thermometerBackground.getHeight() - 55) - d, 30.0, d);
        Graphics2D graphics2D2 = (Graphics2D)this.thermometerBI.getGraphics();
        graphics2D2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D2.drawImage((Image)this.thermometerBackground, 0, 0, null);
        graphics2D2.setColor(Color.RED);
        graphics2D2.fill(double_);
        graphics2D2.drawImage((Image)this.thermometerBody, 0, 0, null);
        graphics2D2.setFont(this.temperatureFont);
        String string = this.formatter.format(this.thermometer.getTemperature()) + GreenhouseResources.getString("ThermometerGraphic.KelvinUnits");
        FontMetrics fontMetrics = graphics2D2.getFontMetrics();
        int n2 = this.thermometerBI.getWidth() - 25;
        int n3 = fontMetrics.getHeight();
        int n4 = this.thermometerBI.getWidth() / 2;
        int n5 = n4 - n2 / 2;
        int n6 = n5 + n2 - fontMetrics.stringWidth(string) - fontMetrics.stringWidth(" ");
        int n7 = 40;
        graphics2D2.setColor(Color.white);
        graphics2D2.fillRect(n5, this.thermometerBI.getHeight() - n7 - n3 + fontMetrics.getDescent(), n2, n3);
        graphics2D2.setColor(Color.black);
        graphics2D2.drawRect(n5, this.thermometerBI.getHeight() - n7 - n3 + fontMetrics.getDescent(), n2, n3);
        graphics2D2.setColor(Color.black);
        graphics2D2.drawString(string, n6, this.thermometerBI.getHeight() - n7);
        double d2 = 0.0;
        String string2 = "";
        if (GreenhouseConfig.TEMPERATURE_UNITS == GreenhouseConfig.FAHRENHEIT) {
            d2 = this.kelvinToFahrenheit(this.thermometer.getTemperature());
            string2 = GreenhouseResources.getString("ThermometerGraphic.FahrenheitUnits");
        } else if (GreenhouseConfig.TEMPERATURE_UNITS == GreenhouseConfig.CELSIUS) {
            d2 = this.kelvinToCelsius(this.thermometer.getTemperature());
            string2 = GreenhouseResources.getString("ThermometerGraphic.CelsiusUnits");
        }
        string = this.formatter.format(d2) + string2;
        graphics2D2.setColor(Color.white);
        graphics2D2.fillRect(n5, this.thermometerBI.getHeight() - (n7 -= n3) - n3 + fontMetrics.getDescent(), n2, n3);
        graphics2D2.setColor(Color.black);
        graphics2D2.drawRect(n5, this.thermometerBI.getHeight() - n7 - n3 + fontMetrics.getDescent(), n2, n3);
        graphics2D2.setColor(Color.black);
        n6 = n5 + n2 - fontMetrics.stringWidth(string) - fontMetrics.stringWidth(" ");
        graphics2D2.drawString(string, n6, this.thermometerBI.getHeight() - n7);
        graphics2D2.dispose();
        graphics2D.drawImage(this.thermometerBI, affineTransform2, null);
    }

    private double kelvinToFahrenheit(double d) {
        double d2 = (d - 273.15) * 1.8 + 32.0;
        return d2;
    }

    private double kelvinToCelsius(double d) {
        double d2 = d - 273.15;
        return d2;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof Thermometer) {
            this.update();
        }
    }

    private void update() {
        this.temperature = this.thermometer.getTemperature();
        this.location.setLocation(this.thermometer.getLocation());
    }
}

